#ifndef SERIALREAD_H
#define SERIALREAD_H

#include <QObject>
#include <QSerialPort>
#include <QSerialPortInfo>
#include <QDebug>
#include <QElapsedTimer>
#include <QMessageBox>
#include <string>
#include <QTimer>
#include <string>
#include <QThread>

class serialread : public QObject
{
    Q_OBJECT
public:
    explicit serialread(QObject *parent = nullptr);
    ~serialread();
     QTimer *myTimer = NULL;

private slots:
    void slotRequestSerialData();

private:
    static const quint16 arduino_uno_vendor_id = 9025;
    static const quint16 arduino_uno_product_id = 67;

    QSerialPort *serial;
    QByteArray serialData;
    QString serialBuffer;
    QThread *serialThread;

public slots:
    void slotCreateSerialPort(QString ComPortName);
    void slotDisconnect();
    void slotSetTimer(bool enable);

signals:
    void signalSendDataToPlot(QStringList buffer_split);

};

#endif // SERIALREAD_H
